define([
    'underscore',
    'backbone',
    'models/resources-collection',
], function(
    _,
    Backbone,
    Resources
) {
    'use strict';

    return Backbone.Model.extend({
        isSecondAttempt: function () {
            return this.has('parentRequest');
        },
        serializeDataToSave: function() {
            var isDeepClone = true;
            var data = _.clone(this.attributes, isDeepClone);

            data.id = data.dataIdentifier.uniqueId;

            if (this.isSecondAttempt()) {
                delete data.appointmentRequestDetailCode;
            }
            delete data.links;
            delete data.dataIdentifier; // removes data.dataIdentifier.systemId

            return data;
        },
        parse: function(response) {
            var selfLink = _.find(response.link, {rel: 'self'});
            selfLink.title = 'self';

            response.links = new Resources(response.link);

            delete response.link;

            return response;
        },
    });
});
